Scriptname _SLSubmitBoundEffect extends activemagiceffect  

_SLSubmitConfig Property _SLConfig Auto
_SLSubmitFunctions Property _SLFunctions Auto
_SLSubmitQuest Property _SLQuest Auto
_SLSubmitScene Property _SLScene Auto

GlobalVariable Property BoundGlobal  Auto  
GlobalVariable Property EscapeBonus  Auto  
GlobalVariable Property RepeatGlobal  Auto
GlobalVariable Property _SLSubmitBoundScene  Auto  

ReferenceAlias Property ActorFollower  Auto
ReferenceAlias Property ActorBully  Auto 
ReferenceAlias Property ActorAssailant1  Auto  
ReferenceAlias Property ActorAssailant2  Auto 
 
Actor Property PlayerRef Auto

ZadLibs Property Libs auto

Topic Property _SLSubmitBoundComments1Topic  Auto 
Topic Property _SLSubmitBoundCommentsCuffs  Auto
Topic Property _SLSubmitBoundCommentsRack  Auto    
Topic Property _SLSubmitBoundCommnetsEnd  Auto
Topic Property _SLSubmitBoundCommentsLegCuffs  Auto 
Topic Property _SLSubmitBoundCommentsKneel  Auto

Spell Property _SLSubmitBully  Auto 
SPELL Property _SLSubmitBullyCloak  Auto  
 
Event OnEffectStart(actor target, actor caster)
	Libs.SetAnimating(PlayerRef,true)
	
	If ActorFollower.GetActorReference() != none
		Libs.SetAnimating(ActorFollower.GetActorReference(), true)
	EndIf
	
	_SLSubmitBoundScene.SetValue(1)
	EvaluatePackage(ActorBully.GetActorReference())
	If ActorBully.GetActorReference() != none
		ActorBully.GetActorReference().SetLookAt(Game.GetPlayer())
	EndIf
	Say(ActorBully.GetActorReference(), _SLSubmitBoundCommentsKneel)
	
	_SLScene.WRT(2.0)
	
	If (BoundGlobal.GetValue() == 0)
		BoundGlobal.SetValue(1)
	EndIf
	
	EscapeBonus.SetValue(0)
	RepeatGlobal.SetValue(0)
	
	If (_SLConfig.debugActive)
		debug.Notification("You have been bound!")
	EndIf
	
	Game.DisablePlayerControls(true, true, false, false, false, true, false, false)
	Debug.SendAnimationEvent(Target, "IdleHandsBehindBack")
	
	If (ActorFollower.GetActorReference() != none)
		Debug.SendAnimationEvent(ActorFollower.GetActorReference(), "IdleHandsBehindBack")
	EndIf
	
	_SLScene.WRT(2.0)
	Debug.SendAnimationEvent(Target, "IdleBoundKneesStart")
	
	If (ActorFollower.GetActorReference() != none)
		Debug.SendAnimationEvent(ActorFollower.GetActorReference(), "IdleBoundKneesStart")
	EndIf
	
	_SLScene.WRT(2.0)

	int deviceCount = 0
	int deviceMax = 1

	If(_SLConfig.LeveledProgActive)
		deviceMax = _SLFunctions.SetDeviceMax(PlayerRef.GetLevel())
	EndIf
	
	;Add Devious Devices before setting bound pose to detect is armbinder (grrrr!) is applied
	Say(ActorBully.GetActorReference(), _SLSubmitBoundComments1Topic)
	_SLScene.WRT(5.0)
	_SLFunctions.DoFadeOut()
	if !PlayerRef.WornHasKeyword(libs.zad_DeviousArmCuffs) && deviceCount < deviceMax
		_SLFunctions.EquipArmCuffs(PlayerRef)
		If (_SLConfig.FollowerActive && ActorFollower.GetActorReference() != none && !ActorFollower.GetActorReference().WornHasKeyword(libs.zad_DeviousArmCuffs))	
			_SLFunctions.EquipArmCuffs(ActorFollower.GetActorReference(), true)
		EndIf
		deviceCount = deviceCount + 1
	EndIf
	
	If !PlayerRef.WornHasKeyword(libs.zad_DeviousLegCuffs) && deviceCount < deviceMax
		_SLFunctions.EquipLegCuffs(PlayerRef)
		If (_SLConfig.FollowerActive && ActorFollower.GetActorReference() != none && !ActorFollower.GetActorReference().WornHasKeyword(libs.zad_DeviousLegCuffs))	
			_SLFunctions.EquipLegCuffs(ActorFollower.GetActorReference(), true)
		EndIf
		deviceCount = deviceCount + 1
	EndIf
	
	If !PlayerRef.WornHasKeyword(libs.zad_DeviousCollar) && (!PlayerRef.WornHasKeyword(libs.zad_DeviousBelt) || !PlayerRef.WornHasKeyword(libs.zad_DeviousHarness)) && deviceCount < deviceMax

		_SLFunctions.ChastityEquipChance(PlayerRef)
		
		If (_SLConfig.FollowerActive && ActorFollower.GetActorReference() != none)
			If (!ActorFollower.GetActorReference().WornHasKeyword(libs.zad_DeviousCollar) || !ActorFollower.GetActorReference().WornHasKeyword(libs.zad_DeviousBelt) || !ActorFollower.GetActorReference().WornHasKeyword(libs.zad_DeviousHarness))
				_SLFunctions.ChastityEquipChance(ActorFollower.GetActorReference())
			EndIf
		EndIf
		deviceCount = deviceCount + 1
	EndIf
	
	If !PlayerRef.WornHasKeyword(libs.zad_DeviousBoots) && deviceCount < deviceMax
		_SLFunctions.EquipBoots(PlayerRef)
		
		If (_SLConfig.FollowerActive && ActorFollower.GetActorReference() != none && !ActorFollower.GetActorReference().WornHasKeyword(libs.zad_DeviousBoots))	
			_SLFunctions.EquipBoots(ActorFollower.GetActorReference(), true)
		EndIf
		deviceCount = deviceCount + 1
	EndIf
	
	If !PlayerRef.WornHasKeyword(libs.zad_DeviousGag) && !PlayerRef.WornHasKeyword(libs.zad_DeviousGagPanel) && deviceCount < deviceMax 
		_SLFunctions.EquipGag(PlayerRef)
		If (_SLConfig.FollowerActive && ActorFollower.GetActorReference() != none && !ActorFollower.GetActorReference().WornHasKeyword(libs.zad_DeviousGag))	
			_SLFunctions.EquipGag(ActorFollower.GetActorReference(), true)
		EndIf
		deviceCount = deviceCount + 1
	EndIf
	
	If !PlayerRef.WornHasKeyword(libs.zad_DeviousBlindfold)	 && deviceCount < deviceMax
		_SLFunctions.EquipBlindFold(PlayerRef)
		If (_SLConfig.FollowerActive && ActorFollower.GetActorReference() != none && !ActorFollower.GetActorReference().WornHasKeyword(libs.zad_DeviousBlindfold))	
			_SLFunctions.EquipBlindFold(ActorFollower.GetActorReference(), true)
		EndIf
		deviceCount = deviceCount + 1
	EndIf
	
	If !PlayerRef.WornHasKeyword(libs.zad_DeviousArmbinder) && deviceCount < deviceMax
		_SLFunctions.EquipArmbinder(PlayerRef)
		
		;If (_SLConfig.FollowerActive && ActorFollower.GetActorReference() != none && !ActorFollower.GetActorReference().WornHasKeyword(libs.zad_DeviousArmbinder))	
		;	EquipArmbinder(ActorFollower.GetActorReference())
		;	RemoveGag(ActorFollower.GetActorReference())
		;EndIf

		If (deviceMax < 8)
			;remove and destroy gag to give player chance to ask for help.
			_SLFunctions.RemoveGag(PlayerRef)
		EndIf
		
		;Set the global bound value to 0 so that everything know you've already escaped due to the armbinder		
		BoundGlobal.SetValue(0)
		_SLFunctions.SetCaptured(false)
	EndIf
	
	If PlayerRef.WornHasKeyword(libs.zad_DeviousArmbinder) || BoundGlobal.GetValue() == 0
		
		If (ActorFollower.GetActorReference() != none )
			Debug.SendAnimationEvent(ActorFollower.GetActorReference(), "IdleForceDefaultState")
			Libs.SetAnimating(ActorFollower.GetActorReference(), false)
		EndIf
		
		;enable player controls just in case they don't get released automatically
		_SLFunctions.DoFadeIn()
		Game.EnablePlayerControls(1,0,1,1,1,0,1)
		Debug.SendAnimationEvent(PlayerRef, "IdleForceDefaultState")
			
		;enable animations from Devious Devices
		Libs.SetAnimating(PlayerRef,false)
		
		;give the player 5 seconds before the enemies start to attack him/her
		_SLScene.WRT(5.0)
		_SLSubmitBoundScene.SetValue(0)
	Else
		if _SLConfig.BondageActive
			;set player bound idle and display 1st part of short story
			_SLFunctions.SetBondageAnimation(PlayerRef)

			;Set follower bound idle if the player has any
			If(ActorFollower.GetActorReference() != none)
				_SLFunctions.SetBondageAnimation(ActorFollower.GetActorReference())
			EndIf
		
			_SLScene.WRT(3.0)
			Say(ActorBully.GetActorReference(), _SLSubmitBoundCommnetsEnd)
		EndIf
		
		_SLFunctions.DoFadeIn()
		_SLFunctions.Moan(PlayerRef)

		If(ActorFollower.GetActorReference() != none)
			_SLFunctions.Moan(ActorFollower.GetActorReference())
		EndIf
		
		_SLScene.WRT(2.0)
		
		If _SLConfig.debugActive
			debug.Notification("You can now attempt to work free of your bindings!")
		EndIf
		_SLSubmitBoundScene.SetValue(0)
		_SLSubmitBully.Cast(PlayerRef)
		EvaluatePackage(ActorBully.GetActorReference())
		BoundGlobal.SetValue(2)
		
		If _SLConfig.RepeatActive
			_SLFunctions.RepeatRate()
		EndIf
	EndIf
EndEvent

;================================
; Wrapper Functions
;================================
Function Say(Actor akActor, Topic sTopic)
	_SLFunctions.Log("Say(" + akActor + "," + sTopic + ")")

	If akActor != none
		akActor.Say(sTopic)
	Else
		_SLFunctions.Warn("Say() called on a None reference")
	EndIf
EndFunction

Function EvaluatePackage(Actor akActor)
	_SLFunctions.Log("EvaluatePackage(" + akActor + ")")

	If akActor != none
		akActor.EvaluatePackage()
	Else
		_SLFunctions.Warn("EvaluatePackage() called on a None reference")
	EndIf
EndFunction
